<?php

namespace App\Entities\Tally\Management;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function workPools()
    {
        return $this->hasMany('App\Entities\Tally\Management\Team', 'team_ids');
    }

}